function warning_config()
% Activates useful warnings
%
% INPUTS
%   none
%
% OUTPUTS
%   none
%
% SPECIAL REQUIREMENTS
%   none

% Copyright © 2008-2026 Dynare Team
%
% This file is part of Dynare.
%
% Dynare is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% Dynare is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with Dynare.  If not, see <https://www.gnu.org/licenses/>.

warning on;

% Display a calling stack trace when a warning is issued
warning('on', 'backtrace');

if isoctave
    warning('off', 'Octave:separator-insert');
    warning('off', 'Octave:language-extension');
    warning('off', 'Octave:single-quote-string');
    warning('off', 'Octave:missing-semicolon');
    warning('off', 'Octave:num-to-str');
    warning('off', 'Octave:str-to-num');
    warning('off', 'Octave:array-as-logical');
    warning('off', 'Octave:array-to-scalar');
    warning('off', 'Octave:array-to-vector');
    warning('off', 'Octave:mixed-string-concat');
    warning('off', 'Octave:variable-switch-label');
    warning('off', 'Octave:legacy-function'); % For strmatch and isdir
    if octave_ver_less_than('11')
        % The following warning was removed in Octave 11
        warning('off', 'Octave:qz:complex-default');

        % The following is necessary because of matlab/+pac/+bgp/{get,set}.m and
        % matlab/+identification/display.m
        % which trigger this bug: https://savannah.gnu.org/bugs/?46849 (fixed in Octave 11)
        warning('off', 'Octave:shadowed-function');

        % The following warning is no longer emitted when saving to a .mat file since Octave 11
        warning('off', 'Octave:classdef-to-struct');
    else
        % Warning emitted when trying to save classdef to a .mat file since Octave 11
        % May no longer be needed when the following is fixed: https://savannah.gnu.org/bugs/?45833
        warning('off', 'Octave:save:classdef:unsupported');
    end
else
    % In MATLAB >= 7.7, don't display a warning if we use deprecated
    % interface to set seed of random number generators
    warning('off', 'MATLAB:RandStream:ActivatingLegacyGenerators');
end

lastwarn('') % Reset lastwarn, used to determine later if a warning has been emitted
