 function MakePlots(Type,Distrib,Mean,gend)
% 
  global options_ fname_ lgy_ lgx_ lgy_TeX_ lgx_TeX_ dr_ bayestopt_
  
  TeX  = options_.TeX;
  dim  = size(Distrib,3);
  
  if strcmpi(Type,'SmoothedVariables')
    generic = 'SmoothedVariables';
    figname = 'Smoothed variables';
    AllNames = lgy_(dr_.order_var,:);
    if TeX
      AllTeXNames = lgy_TeX_(dr_.order_var,:);
    end
    [nbplt,nr,nc,lr,lc,nstar] = pltorg(size(lgy_,1));
    numb = size(lgy_,1);
  elseif strcmpi(Type,'SmoothedShocks')
    generic = 'SmoothedShocks';
    figname = 'Smoothed shocks';
    AllNames = lgx_;
    if TeX
      AllTeXNames = lgx_TeX_;
    end
    [nbplt,nr,nc,lr,lc,nstar] = pltorg(size(lgx_,1));
    numb = size(lgx_,1);
  elseif strcmpi(Type,'SmoothedObservationErrors')
    generic = 'SmoothedObservationErrors';
    figname = 'Smoothed observation errors';
    nvobs = size(options_.varobs,1);
    numb = 0;
    index = [];
    for i=1:nvobs
      if max(abs(Mean(i,10:end))) > 0.00000001
	numb = numb + 1;
	index = cat(1,index,i);
      end
    end
    Distrib = Distrib(index,:,:);
    Mean = Mean(index,:);
    [nbplt,nr,nc,lr,lc,nstar] = pltorg(numb);
    AllNames = options_.varobs(index,:);
    if TeX
      AllTeXNames = options_.varobs_TeX(index,:);
    end
  elseif strcmpi(Type,'Historical&SmoothedObservableVariables')
    generic = 'HistoricalAndSmoothedVariables';
    figname = 'Historical and smoothed observed variables.';
    numb = size(options_.varobs,1);
    [nbplt,nr,nc,lr,lc,nstar] = pltorg(numb);
    AllNames = options_.varobs;
    if TeX
      AllTeXNames = options_.varobs_TeX;
    end
    Distrib = Distrib(bayestopt_.mf,:);
  elseif strcmpi(Type,'FilteredVariables')
    generic = 'FilteredVariables';
    figname = 'Filtered variables';
    AllNames = lgy_(dr_.order_var,:);
    if TeX
      AllTeXNames = lgy_TeX_(dr_.order_var,:);
    end
    [nbplt,nr,nc,lr,lc,nstar] = pltorg(size(lgy_,1));
    numb = size(lgy_,1);
  end    
  
  if TeX
    fidTeX = fopen([fname_ '_' generic '.TeX'],'w');
    fprintf(fidTeX,'%% TeX eps-loader file generated by metropolis.m (Dynare).\n');
    fprintf(fidTeX,['%% ' datestr(now,0) '\n']);
    fprintf(fidTeX,' \n');
  end
  
  if nbplt == 1
    hh = figure('Name',figname);
    NAMES = [];
    if TeX, TEXNAMES = [], end
    for i=1:numb
      set(0,'CurrentFigure',hh)
      subplot(nr,nc,i);
      test = ~(all(all(Distrib(i,:,:)>0)) | all(all(Distrib(i,:,:)<0)));
      if test & ~strcmpi(Type,'Historical&SmoothedObservableVariables')  
	plot([1 gend],[0 0],'-r','linewidth',0.5);
      end
      hold on
      for j = 1:min(9,dim)
	plot(1:gend,Distrib(i,:,j),'-g','linewidth',0.5)
      end
      plot(1:gend,Mean(i,:),'-k','linewidth',1)
      xlim([1 gend]);
      box on
      hold off      
      ih = figure('Visible','off');
      set(0,'CurrentFigure',ih)
      if test & ~strcmpi(Type,'Historical&SmoothedObservableVariables') 
	plot([1 gend],[0 0],'-r','linewidth',0.5);
      end
      hold on
      for j = 1:min(9,dim)
	plot(1:gend,Distrib(i,:,j),'-g','linewidth',0.5)
      end
      plot(1:gend,Mean(i,:),'-k','linewidth',1)
      xlim([1 gend]);
      box on
      hold off
      name = deblank(AllNames(i,:));
      NAMES   = strvcat(NAMES,name);
      if ~isempty(options_.XTick)
	set(gca,'XTick',options_.XTick)
	set(gca,'XTickLabel',options_.XTickLabel)
      end
      eval(['print -depsc2 ' fname_ '_' generic '_' name]);
      eval(['print -dpdf ' fname_ '_' generic '_' name]);
      saveas(ih,[fname_ '_' generic '_' name '.fig']);
      if TeX
	texname = deblank(AllTeXNames(i,:));
	TEXNAMES = strvcat(TEXNAMES,['$' texname '$']);
      end
      set(0,'CurrentFigure',hh)
      title(name,'Interpreter','none')
      if ~isempty(options_.XTick)
	set(gca,'XTick',options_.XTick)
	set(gca,'XTickLabel',options_.XTickLabel)
      end
    end
    eval(['print -depsc2 ' fname_ '_' generic int2str(1)]);
    eval(['print -dpdf ' fname_ '_' generic int2str(1)]);
    saveas(hh,[fname_ '_' generic int2str(1) '.fig']);
    if options_.nograph, close(hh), end
    if TeX
      fprintf(fidTeX,'\\begin{figure}[H]\n');
      for jj = 1:numb
	fprintf(fidTeX,['\\psfrag{%s}[1][][0.5][0]{%s}\n'],deblank(NAMES(jj,:)),deblank(TEXNAMES(jj,:)));
      end    
      fprintf(fidTeX,'\\centering \n');
      fprintf(fidTeX,'\\includegraphics[scale=0.5]{%s_%s%s}\n',fname_,generic,int2str(1));
      fprintf(fidTeX,'\\caption{%s.}',figname);
      fprintf(fidTeX,'\\label{Fig:%s:%s}\n',generic,int2str(1));
      fprintf(fidTeX,'\\end{figure}\n');
      fprintf(fidTeX,' \n');
      fprintf(fidTeX,'%% End of TeX file.\n');
      fclose(fidTeX);
    end
  else
    for plt = 1:nbplt-1
      hh = figure('Name',figname);
      NAMES = [];
      TEXNAMES = [];
      for i=1:nstar
	k = (plt-1)*nstar+i;
	set(0,'CurrentFigure',hh)
	subplot(nr,nc,i);
	test = ~(all(all(Distrib(k,:,:)>0)) | all(all(Distrib(k,:,:)<0))); 
	if test & ~strcmpi(Type,'Historical&SmoothedObservableVariables')
	  plot([1 gend],[0 0],'-r','linewidth',0.5);
	end
	hold on
	for j = 1:min(9,dim)
	  plot(1:gend,Distrib(k,:,j),'-g','linewidth',0.5)
	end
	plot(1:gend,Mean(k,:),'-k','linewidth',1)
	xlim([1 gend]);
	box on
	hold off
	name = deblank(AllNames(k,:));
	NAMES = strvcat(NAMES,name);
	ih = figure('Visible','off');
	set(0,'CurrentFigure',ih)
	if test & ~strcmpi(Type,'Historical&SmoothedObservableVariables')  
	  plot([1 gend],[0 0],'-r','linewidth',0.5);
	end
	hold on
	for j = 1:min(9,dim)
	  plot(1:gend,Distrib(k,:,j),'-g','linewidth',0.5)
	end
	plot(1:gend,Mean(k,:),'-k','linewidth',1)
	xlim([1 gend]);
	box on
	hold off
	if ~isempty(options_.XTick)
	  set(gca,'XTick',options_.XTick)
	  set(gca,'XTickLabel',options_.XTickLabel)
	end
	eval(['print -depsc2 ' fname_ '_' generic '_' name]);
	eval(['print -dpdf ' fname_ '_' generic '_' name]);
	saveas(ih,[fname_ '_' generic '_' name '.fig']);
	if TeX
	  texname = deblank(AllTeXNames(k,:));
	  TEXNAMES = strvcat(TEXNAMES,['$' texname '$']);    
	end
	set(0,'CurrentFigure',hh)
	title(name,'Interpreter','none')
	if ~isempty(options_.XTick)
	  set(gca,'XTick',options_.XTick)
	  set(gca,'XTickLabel',options_.XTickLabel)
	end
      end
      eval(['print -depsc2 ' fname_ '_' generic int2str(plt)]);
      eval(['print -dpdf ' fname_ '_' generic int2str(plt)]);
      saveas(hh,[fname_ '_' generic int2str(plt) '.fig']);
      if options_.nograph, close(hh), end
      if TeX
	fprintf(fidTeX,'\\begin{figure}[H]\n');
	for jj = 1:nstar
	  fprintf(fidTeX,'\\psfrag{%s}[1][][0.5][0]{%s}\n',deblank(NAMES(jj,:)),deblank(TEXNAMES(jj,:)));
	end    
	fprintf(fidTeX,'\\centering \n');
	fprintf(fidTeX,'\\includegraphics[scale=0.5]{%s_%s%s}\n',fname_,generic,int2str(plt));
	fprintf(fidTeX,'\\caption{%s.}',figname);
	fprintf(fidTeX,'\\label{Fig:%s:%s}\n',generic,int2str(plt));
	fprintf(fidTeX,'\\end{figure}\n');
	fprintf(fidTeX,' \n');
      end    
    end
    hh = figure('Name',figname);
    NAMES = [];
    TEXNAMES = [];
    for i=1:numb-(nbplt-1)*nstar
      k = (nbplt-1)*nstar+i;
      set(0,'CurrentFigure',hh)
      if lr ~= 0
	subplot(lr,lc,i);
      else
	subplot(nr,nc,i);
      end
      test = ~(all(all(Distrib(k,:,:)>0)) | all(all(Distrib(k,:,:)<0)));
      if test & ~strcmpi(Type,'Historical&SmoothedObservableVariables') 
	plot([1 gend],[0 0],'-r','linewidth',0.5);
      end
      hold on
      for j = 1:min(9,dim)
	plot(1:gend,Distrib(k,:,j),'-g','linewidth',0.5)
      end
      plot(1:gend,Mean(k,:),'-k','linewidth',1)
      xlim([1 gend]);
      box on
      hold off
      name = deblank(AllNames(k,:));
      NAMES    = strvcat(NAMES,name);
      ih = figure('Visible','off');
      set(0,'CurrentFigure',ih)
      if test & ~strcmpi(Type,'Historical&SmoothedObservableVariables')  
	plot([1 gend],[0 0],'-r','linewidth',0.5);
      end
      hold on
      for j = 1:min(9,dim)
	plot(1:gend,Distrib(k,:,j),'-g','linewidth',0.5)
      end
      plot(1:gend,Mean(k,:),'-k','linewidth',1)
      xlim([1 gend]);
      box on
      hold off
      if ~isempty(options_.XTick)
	set(gca,'XTick',options_.XTick)
	set(gca,'XTickLabel',options_.XTickLabel)
      end
      eval(['print -depsc2 ' fname_ '_' generic  '_' name]);
      eval(['print -dpdf ' fname_ '_' generic '_' name]);
      saveas(ih,[fname_ '_' generic '_' name '.fig']);
      if TeX
	texname  = deblank(AllTeXNames(k,:));
	TEXNAMES = strvcat(TEXNAMES,['$' texname '$']);
      end
      set(0,'CurrentFigure',hh)
      title(name,'Interpreter','none');
      if ~isempty(options_.XTick)
	set(gca,'XTick',options_.XTick)
	set(gca,'XTickLabel',options_.XTickLabel)
      end
    end
    eval(['print -depsc2 ' fname_ '_' generic int2str(nbplt)]);
    eval(['print -dpdf ' fname_ '_' generic int2str(nbplt)]);
    saveas(hh,[fname_ '_' generic int2str(nbplt) '.fig']);
    if options_.nograph, close(hh), end
    if TeX
      fprintf(fidTeX,'\\begin{figure}[H]\n');
      for jj = 1:size(NAMES,1);
	fprintf(fidTeX,'\\psfrag{%s}[1][][0.5][0]{%s}\n',deblank(NAMES(jj,:)),deblank(TEXNAMES(jj,:)));
      end    
      fprintf(fidTeX,'\\centering \n');
      fprintf(fidTeX,'\\includegraphics[scale=0.5]{%s_%s%s}\n',fname_,generic,int2str(nbplt));
      fprintf(fidTeX,'\\caption{%s.}',figname);
      fprintf(fidTeX,'\\label{Fig:%s:%s}\n',generic,int2str(nbplt));
      fprintf(fidTeX,'\\end{figure}\n');
      fprintf(fidTeX,'\n');
      fprintf(fidTeX,'%% End of TeX file.\n');
      fclose(fidTeX);
    end
  end




