% Copyright (C) 2001 Michel Juillard
%
function disp_th_moments(dr,var_list)
global endo_nbr exo_nbr lgy_ lgx_ Gamma_y lgx_orig_ord_ options_ oo_
global lgy_TeX_ lgx_TeX_ fname_ options_

TeX = options_.TeX;
MaxCol = 6;

nvar = size(var_list,1);
if nvar == 0
  nvar  = length(dr.order_var);
  ivar  = transpose(1:nvar);
  var_list = lgy_;
else
  ivar=zeros(nvar,1);
  if TeX
    var_listTeX = [];
  end
  for i=1:nvar
    i_tmp = strmatch(var_list(i,:),lgy_,'exact');
    if isempty(i_tmp)
      error (['One of the variable specified does not exist']) ;
    else
      ivar(i) = i_tmp;
      if TeX
	var_listTeX = strvcat(var_listTeX,deblank(lgy_TeX_(i_tmp,:)));
      end
    end	
  end
end

[Gamma_y,ivar] = th_autocovariances(dr,ivar);
m = dr.ys(ivar);

i1 = find(abs(diag(Gamma_y{1})) > 1e-12);
s2 = diag(Gamma_y{1});
sd = sqrt(s2);
if options_.order == 2
  m = m+Gamma_y{options_.ar+3};
end
  
z = [ m sd s2 ];
oo_.mean = m;
oo_.var = Gamma_y{1};
for i=1:options_.ar
  oo_.autocorr{i}=Gamma_y{i+1};
end

if TeX
  filename = [fname_ '_Posterior_ThMoments1.TeX'];
  fidTeX = fopen(filename,'w');
  fprintf(fidTeX,'%% TeX-table generated by disp_th_moments (Dynare).\n');
  fprintf(fidTeX,['%% ' datestr(now,0)]);
  fprintf(fidTeX,' \n');
  fprintf(fidTeX,' \n');
  fprintf(fidTeX,'{\\tiny \n')
  fprintf(fidTeX,'\\begin{table}\n');
  fprintf(fidTeX,'\\centering\n');
  fprintf(fidTeX,'\\begin{tabular}{l|cc} \n');
  fprintf(fidTeX,'\\hline\\hline \\\\ \n');
  fprintf(fidTeX,' Variable  & Theoretical expectation & Theoretical variance \\\\ \n');
  fprintf(fidTeX,'\\hline \\\\ \n');
  for i=1:nvar
    fprintf(fidTeX,'$%s$ & %7.3f & %7.3f \\\\ \n',...
	    deblank(var_listTeX(i,:)),...
	    m(i),...
	    oo_.var(i,i));
  end
  fprintf(fidTeX,'\\hline\\hline \n');
  fprintf(fidTeX,'\\end{tabular}\n ');    
  fprintf(fidTeX,'\\caption{Posterior expectations and variances.}\n ');
  fprintf(fidTeX,'\\label{Table:Posterior:ThMoments:1}\n');
  fprintf(fidTeX,'\\end{table}\n');
  fprintf(fidTeX,'} \n')
  fprintf(fidTeX,'%% End of TeX file.\n');
  fclose(fidTeX);
end


lh = size(deblank(lgy_(ivar,:)),2)+2;
if options_.nomoments == 0
  if ~options_.noprint
    title='THEORETICAL MOMENTS';
    if options_.hp_filter > 1
      title = [title ' (HP filter, lambda = ' int2str(options_.hp_filter) ')'];
    end
    headers=strvcat('VARIABLE','MEAN','STD. DEV.','VARIANCE');
    table(title,headers,deblank(lgy_(ivar,:)),z,lh,11,4);
    if exo_nbr > 1
      disp(' ')
      title='VARIANCE DECOMPOSITION (in percent)';
      if options_.hp_filter > 1
	title = [title ' (HP filter, lambda = ' ...
		 int2str(options_.hp_filter) ')'];
      end
      headers = lgx_;
      headers(lgx_orig_ord_,:) = headers;
      headers = strvcat(' ',headers);
      table(title,headers,deblank(lgy_(ivar(i1),:)),100*Gamma_y{options_.ar+2}(i1,:), ...
	    lh,8,2);
    end
    if TeX
      PostDeComp = Gamma_y{options_.ar+2};
      ntabs = ceil(exo_nbr/MaxCol);
      reste = exo_nbr-(ntabs-1)*MaxCol;
      TeXheaders(lgx_orig_ord_,:) = lgx_TeX_;
      filename = [fname_ '_Posterior_ThDeComp.TeX'];
      fidTeX = fopen(filename,'w');
      fprintf(fidTeX,'%% TeX-table generated by disp_th_moments (Dynare).\n');
      fprintf(fidTeX,['%% ' datestr(now,0)]);
      fprintf(fidTeX,' \n');
      fprintf(fidTeX,' \n');
      for tab = 1:ntabs-1
	fprintf(fidTeX,'{\\tiny \n')
	fprintf(fidTeX,'\\begin{table}\n');
	fprintf(fidTeX,'\\centering\n');
	fprintf(fidTeX,'\\begin{tabular}{l|cccccc} \n');
	fprintf(fidTeX,'\\hline\\hline \\\\ \n');
	fprintf(fidTeX,' Variable  & $%s$ & $%s$ & $%s$ & $%s$ & $%s$ & $%s$ \\\\ \n',...
		deblank(TeXheaders((tab-1)*MaxCol+1,:)),...
		deblank(TeXheaders((tab-1)*MaxCol+2,:)),...
		deblank(TeXheaders((tab-1)*MaxCol+3,:)),...
		deblank(TeXheaders((tab-1)*MaxCol+4,:)),...
		deblank(TeXheaders((tab-1)*MaxCol+5,:)),...
		deblank(TeXheaders((tab-1)*MaxCol+6,:)));
	fprintf(fidTeX,'\\hline \\\\ \n');
	for i=1:nvar
	  fprintf(fidTeX,'$%s$ & %4.2f & %4.2f & %4.2f & %4.2f & %4.2f & %4.2f \\\\ \n',...
		  deblank(var_listTeX(i,:)),...
		  PostDeComp(i,(tab-1)*MaxCol+1),...
		  PostDeComp(i,(tab-1)*MaxCol+2),...
		  PostDeComp(i,(tab-1)*MaxCol+3),...
		  PostDeComp(i,(tab-1)*MaxCol+4),...
		  PostDeComp(i,(tab-1)*MaxCol+5),...
		  PostDeComp(i,(tab-1)*MaxCol+6));
	end
	fprintf(fidTeX,'\\hline\\hline \n');
	fprintf(fidTeX,'\\end{tabular}\n ');
	fprintf(fidTeX,'\\caption{Variance decomposition}\n');
	fprintf(fidTeX,'\\label{Table:Posterior:ThDeComp:%s}\n',int2str(tab));
	fprintf(fidTeX,'\\end{table}\n');
	fprintf(fidTeX,'} \n')
	fprintf(fidTeX,' \n');
      end
      if reste == 6
	fprintf(fidTeX,'{\\tiny \n')
	fprintf(fidTeX,'\\begin{table}\n');
	fprintf(fidTeX,'\\centering\n');
	fprintf(fidTeX,'\\begin{tabular}{l|cccccc} \n');
	fprintf(fidTeX,'\\hline\\hline \\\\ \n');
	fprintf(fidTeX,' Variable  & $%s$ & $%s$ & $%s$ & $%s$ & $%s$ & $%s$ \\\\ \n',...
		deblank(TeXheaders((ntabs-1)*MaxCol+1,:)),...
		deblank(TeXheaders((ntabs-1)*MaxCol+2,:)),...
		deblank(TeXheaders((ntabs-1)*MaxCol+3,:)),...
		deblank(TeXheaders((ntabs-1)*MaxCol+4,:)),...
		deblank(TeXheaders((ntabs-1)*MaxCol+5,:)),...
		deblank(TeXheaders((ntabs-1)*MaxCol+6,:)));
	fprintf(fidTeX,'\\hline \\\\ \n');
	for i=1:nvar
	  fprintf(fidTeX,'$%s$ & %4.2f & %4.2f & %4.2f & %4.2f & %4.2f & %4.2f \\\\ \n',...
		  deblank(var_listTeX(i,:)),...
		  PostDeComp(i,(ntabs-1)*MaxCol+1),...
		  PostDeComp(i,(ntabs-1)*MaxCol+2),...
		  PostDeComp(i,(ntabs-1)*MaxCol+3),...
		  PostDeComp(i,(ntabs-1)*MaxCol+4),...
		  PostDeComp(i,(ntabs-1)*MaxCol+5),...
		  PostDeComp(i,(ntabs-1)*MaxCol+6));
	end
	fprintf(fidTeX,'\\hline\\hline \n');
	fprintf(fidTeX,'\\end{tabular}\n ');    
	fprintf(fidTeX,'\\caption{Variance decomposition.}\n ');
	fprintf(fidTeX,'\\label{Table:Posterior:ThDeComp:%s}\n',int2str(ntabs));
	fprintf(fidTeX,'\\end{table}\n');
	fprintf(fidTeX,'} \n')
	fprintf(fidTeX,' \n');
	fprintf(fidTeX,'%% End Of TeX File.')
	fclose(fidTeX);
      elseif reste == 5
	fprintf(fidTeX,'{\\tiny \n')
	fprintf(fidTeX,'\\begin{table}\n');
	fprintf(fidTeX,'\\centering\n');
	fprintf(fidTeX,'\\begin{tabular}{l|ccccc} \n');
	fprintf(fidTeX,'\\hline\\hline \\\\ \n');
	fprintf(fidTeX,' Variable  & $%s$ & $%s$ & $%s$ & $%s$ & $%s$ \\\\ \n',...
		deblank(TeXheaders((ntabs-1)*MaxCol+1,:)),...
		deblank(TeXheaders((ntabs-1)*MaxCol+2,:)),...
		deblank(TeXheaders((ntabs-1)*MaxCol+3,:)),...
		deblank(TeXheaders((ntabs-1)*MaxCol+4,:)),...
		deblank(TeXheaders((ntabs-1)*MaxCol+5,:)));
	fprintf(fidTeX,'\\hline \\\\ \n');
	for i=1:nvar
	  fprintf(fidTeX,'$%s$ & %4.2f & %4.2f & %4.2f & %4.2f & %4.2f \\\\ \n',...
		  deblank(var_listTeX(i,:)),...
		  PostDeComp(i,(ntabs-1)*MaxCol+1),...
		  PostDeComp(i,(ntabs-1)*MaxCol+2),...
		  PostDeComp(i,(ntabs-1)*MaxCol+3),...
		  PostDeComp(i,(ntabs-1)*MaxCol+4),...
		  PostDeComp(i,(ntabs-1)*MaxCol+5));
	end
	fprintf(fidTeX,'\\hline\\hline \n');
	fprintf(fidTeX,'\\end{tabular}\n ');    
	fprintf(fidTeX,'\\caption{Variance decomposition}\n ');
	fprintf(fidTeX,'\\label{Table:Posterior:ThDeComp:%s}\n',int2str(ntabs));
	fprintf(fidTeX,'\\end{table}\n');
	fprintf(fidTeX,'} \n')
	fprintf(fidTeX,' \n');
	fprintf(fidTeX,'%% End Of TeX File.')
	fclose(fidTeX);
      elseif reste == 4
	fprintf(fidTeX,'{\\tiny \n')
	fprintf(fidTeX,'\\begin{table}\n');
	fprintf(fidTeX,'\\centering\n');
	fprintf(fidTeX,'\\begin{tabular}{l|cccc} \n');
	fprintf(fidTeX,'\\hline\\hline \\\\ \n');
	fprintf(fidTeX,' Variable  & $%s$ & $%s$ & $%s$ & $%s$ \\\\ \n',...
		deblank(TeXheaders((ntabs-1)*MaxCol+1,:)),...
		deblank(TeXheaders((ntabs-1)*MaxCol+2,:)),...
		deblank(TeXheaders((ntabs-1)*MaxCol+3,:)),...
		deblank(TeXheaders((ntabs-1)*MaxCol+4,:)));
	fprintf(fidTeX,'\\hline \\\\ \n');
	for i=1:nvar
	  fprintf(fidTeX,'$%s$ & %4.2f & %4.2f & %4.2f & %4.2f \\\\ \n',...
		  deblank(var_listTeX(i,:)),...
		  PostDeComp(i,(ntabs-1)*MaxCol+1),...
		  PostDeComp(i,(ntabs-1)*MaxCol+2),...
		  PostDeComp(i,(ntabs-1)*MaxCol+3),...
		  PostDeComp(i,(ntabs-1)*MaxCol+4));
	end
	fprintf(fidTeX,'\\hline\\hline \n');
	fprintf(fidTeX,'\\end{tabular}\n ');    
	fprintf(fidTeX,'\\caption{Variance decomposition}\n ');
	fprintf(fidTeX,'\\label{Table:Posterior:ThDeComp:%s}\n',int2str(ntabs));
	fprintf(fidTeX,'\\end{table}\n');
	fprintf(fidTeX,'} \n')
	fprintf(fidTeX,' \n');
	fprintf(fidTeX,'%% End Of TeX File.')
	fclose(fidTeX);
      elseif reste == 3
	fprintf(fidTeX,'{\\tiny \n')
	fprintf(fidTeX,'\\begin{table}\n');
	fprintf(fidTeX,'\\centering\n');
	fprintf(fidTeX,'\\begin{tabular}{l|ccc} \n');
	fprintf(fidTeX,'\\hline\\hline \\\\ \n');
	fprintf(fidTeX,' Variable  & $%s$ & $%s$ & $%s$ \\\\ \n',...
		deblank(TeXheaders((ntabs-1)*MaxCol+1,:)),...
		deblank(TeXheaders((ntabs-1)*MaxCol+2,:)),...
		deblank(TeXheaders((ntabs-1)*MaxCol+3,:)));
	fprintf(fidTeX,'\\hline \\\\ \n');
	for i=1:nvar
	  fprintf(fidTeX,'$%s$ & %4.2f & %4.2f & %4.2f \\\\ \n',...
		  deblank(var_listTeX),...
		  PostDeComp(i,(ntabs-1)*MaxCol+1),...
		  PostDeComp(i,(ntabs-1)*MaxCol+2),...
		  PostDeComp(i,(ntabs-1)*MaxCol+3));
	end
	fprintf(fidTeX,'\\hline\\hline \n');
	fprintf(fidTeX,'\\end{tabular}\n ');    
	fprintf(fidTeX,'\\caption{Variance decomposition}\n ');
	fprintf(fidTeX,'\\label{Table:Posterior:ThDeComp:%s}\n',int2str(ntabs));
	fprintf(fidTeX,'\\end{table}\n');
	fprintf(fidTeX,'} \n')
	fprintf(fidTeX,' \n');
	fprintf(fidTeX,'%% End Of TeX File.')
	fclose(fidTeX);
      elseif reste == 2
	fprintf(fidTeX,'{\\tiny \n')
	fprintf(fidTeX,'\\begin{table}\n');
	fprintf(fidTeX,'\\centering\n');
	fprintf(fidTeX,'\\begin{tabular}{l|cc} \n');
	fprintf(fidTeX,'\\hline\\hline \\\\ \n');
	fprintf(fidTeX,' Variable  & $%s$ & $%s$ \\\\ \n',...
		deblank(TeXheaders((ntabs-1)*MaxCol+1,:)),...
		deblank(TeXheaders((ntabs-1)*MaxCol+2,:)));
	fprintf(fidTeX,'\\hline \\\\ \n');
	for i=1:nvar
	  fprintf(fidTeX,'$%s$ & %4.2f & %4.2f \\\\ \n',...
		  deblank(var_listTeX),...
		  PostDeComp(i,(ntabs-1)*MaxCol+1),...
		  PostDeComp(i,(ntabs-1)*MaxCol+2));
	end
	fprintf(fidTeX,'\\hline\\hline \n');
	fprintf(fidTeX,'\\end{tabular}\n ');    
	fprintf(fidTeX,'\\caption{Variance decomposition}\n ');
	fprintf(fidTeX,'\\label{Table:Posterior:ThDeComp:%s}\n',int2str(ntabs));
	fprintf(fidTeX,'\\end{table}\n');
	fprintf(fidTeX,'} \n')
	fprintf(fidTeX,' \n');
	fprintf(fidTeX,'%% End Of TeX File.')
	fclose(fidTeX);
      elseif reste == 1
	fprintf(fidTeX,'{\\tiny \n')
	fprintf(fidTeX,'\\begin{table}\n');
	fprintf(fidTeX,'\\centering\n');
	fprintf(fidTeX,'\\begin{tabular}{l|c} \n');
	fprintf(fidTeX,'\\hline\\hline \\\\ \n');
	fprintf(fidTeX,' Variable  & $%s$ \\\\ \n',...
		deblank(TeXheaders((ntabs-1)*MaxCol+1,:)));
	fprintf(fidTeX,'\\hline \\\\ \n');
	for i=1:nvar
	  fprintf(fidTeX,'$%s$ & %4.2f \\\\ \n',...
		  deblank(var_listTeX),...
		  PostDeComp(i,(ntabs-1)*MaxCol+1));
	end
	fprintf(fidTeX,'\\hline\\hline \n');
	fprintf(fidTeX,'\\end{tabular}\n ');    
	fprintf(fidTeX,'\\caption{Variance decomposition}\n ');
	fprintf(fidTeX,'\\label{Table:Posterior:ThDeComp:%s}\n',int2str(ntabs));
	fprintf(fidTeX,'\\end{table}\n');
	fprintf(fidTeX,'} \n')
	fprintf(fidTeX,' \n');
	fprintf(fidTeX,'%% End Of TeX File.')
	fclose(fidTeX);
      end	
    end
  end
end

if options_.nocorr == 0 & ~options_.noprint
    disp(' ')
    title='MATRIX OF CORRELATIONS';
    if options_.hp_filter > 1
      title = [title ' (HP filter, lambda = ' int2str(options_.hp_filter) ')'];
    end
    labels = deblank(lgy_(ivar,:));
    headers = strvcat('Variables',labels(i1,:));
    corr = Gamma_y{1}(i1,i1)./(sd(i1)*sd(i1)');
    table(title,headers,labels(i1,:),corr,lh,8,4);
end
  
if options_.ar > 0
  for i=1:options_.ar
    oo_.autocorr{i} = Gamma_y{i+1};
  end
  if ~options_.noprint
    disp(' ')
    title='COEFFICIENTS OF AUTOCORRELATION';
    if options_.hp_filter > 1
      title = [title ' (HP filter, lambda = ' int2str(options_.hp_filter) ')'];
    end
    labels = deblank(lgy_(ivar(i1),:));
    headers = strvcat('Order ',int2str([1:options_.ar]'));
    z=[];
    for i=1:options_.ar
      z(:,i) = diag(Gamma_y{i+1}(i1,i1));
    end
    table(title,headers,labels,z,0,8,4);
  end
end
  
% 10/09/02 MJ 
% 10/18/02 MJ added th_autocovariances() and provided for lags on several
% periods
% 10/30/02 MJ added correlations and autocorrelations, uses table()
%             Gamma_y is now a cell array.
% 02/18/03 MJ added subtitles for HP filter
% 05/01/03 MJ corrected options_.hp_filter
% 05/21/03 MJ variance decomposition: test exo_nbr > 1
% 05/21/03 MJ displays only variables with positive variance
% 04/03/05 SA added silent mode