function mode_check(x,fval,hessian,gend,data,lb,ub)
global bayestopt_ fname_ options_

TeX = options_.TeX;
[s_min,k] = min(diag(hessian))
  
disp('\nMODE CHECK\n')
disp(sprintf('Fval obtained by fmincon: %f', fval))
disp(bayestopt_.name)
cname = bayestopt_.name{k};
disp(sprintf('Most negative variance %f for parameter %d (%s = %f)',s_min,k,cname,x(k)))

[nbplt,nr,nc,lr,lc,nstar] = pltorg(length(x));

if TeX
    fidTeX = fopen([fname_ '_CheckPlots.TeX'],'w');
    fprintf(fidTeX,'%% TeX eps-loader file generated by mode_check.m (Dynare).\n');
    fprintf(fidTeX,['%% ' datestr(now,0) '\n']);
    fprintf(fidTeX,' \n');
end


if nbplt == 1
    if TeX
        NAMES = [];
        TeXNAMES = [];
    end    
    hh = figure('Name','Check plots');
    for k=1:length(x)
        subplot(nr,nc,k)
        [name,texname] = get_the_name(k,TeX);
        if TeX
            NAMES = strvcat(NAMES,name);
            TeXNAMES = strvcat(TeXNAMES,texname);
        end    
        xx = x;
        l1 = max(lb(k),0.8*x(k)); % kk -> k
        l2 = min(ub(k),1.2*x(k)); % kk -> k
        z = [l1:(l2-l1)/20:l2];
        y = zeros(length(z),1);
        for i=1:length(z)
            xx(k) = z(i); % kk -> k
            y(i) = DsgeLikelihood(xx,gend,data);
        end
        plot(z,y)
        hold on
        yl=get(gca,'ylim');
        plot([x(k) x(k)],yl,'c','LineWidth', 1);% kk -> k
        title(name,'interpreter','none');
        hold off
        drawnow
    end
    eval(['print -depsc2 ' fname_ '_CheckPlots' int2str(1)]);
    eval(['print -dpdf ' fname_ '_CheckPlots' int2str(1)]);
    saveas(hh,[fname_ '_CheckPlots' int2str(1) '.fig']);
    if options_.nograph, close(hh), end  
    % TeX eps loader file
    if TeX
        fprintf(fidTeX,'\\begin{figure}[H]\n');
        for jj = 1:length(x)
            fprintf(fidTeX,'\\psfrag{%s}[1][][0.5][0]{%s}\n',deblank(NAMES(jj,:)),deblank(TeXNAMES(jj,:)));
        end    
        fprintf(fidTeX,'\\centering \n');
        fprintf(fidTeX,'\\includegraphics[scale=0.5]{%s_CheckPlots%s}\n',fname_,int2str(1));
        fprintf(fidTeX,'\\caption{Priors.}');
        fprintf(fidTeX,'\\label{Fig:CheckPlots:%s}\n',int2str(1));
        fprintf(fidTeX,'\\end{figure}\n');
        fprintf(fidTeX,'\n');
        fprintf(fidTeX,'%% End of TeX file.\n');
        fclose(fidTeX);
    end    
else
    for plt = 1:nbplt-1
        if TeX
            NAMES = [];
            TeXNAMES = [];
        end    
        hh = figure('Name','Check plots');
        for k=1:nstar
            subplot(nr,nc,k)
            kk = (plt-1)*nstar+k;
            [name,texname] = get_the_name(kk,TeX);
            if TeX
                NAMES = strvcat(NAMES,name);
                TeXNAMES = strvcat(TeXNAMES,texname);
            end    
            xx = x;
            l1 = max(lb(kk),0.8*x(kk));
            l2 = min(ub(kk),1.2*x(kk));
            z = [l1:(l2-l1)/20:l2];
            y = zeros(length(z),1);
            for i=1:length(z)
                xx(kk) = z(i);
                y(i) = DsgeLikelihood(xx,gend,data);
            end
            plot(z,y);
            hold on
            yl=get(gca,'ylim');
            plot( [x(kk) x(kk)], yl, 'c', 'LineWidth', 1)
            title(name,'interpreter','none')
            hold off
            drawnow
        end    
        eval(['print -depsc2 ' fname_ '_CheckPlots' int2str(plt)]);
        eval(['print -dpdf ' fname_ '_CheckPlots' int2str(plt)]);
        saveas(hh,[fname_ '_CheckPlots' int2str(plt) '.fig']);
        if options_.nograph, close(hh), end
        if TeX
            % TeX eps loader file    
            fprintf(fidTeX,'\\begin{figure}[H]\n');
            for jj = 1:nstar
                fprintf(fidTeX,'\\psfrag{%s}[1][][0.5][0]{%s}\n',deblank(NAMES(jj,:)),deblank(TeXNAMES(jj,:)));
            end    
            fprintf(fidTeX,'\\centering \n');
            fprintf(fidTeX,'\\includegraphics[scale=0.5]{%s_CheckPlots%s}\n',fname_,int2str(plt));
            fprintf(fidTeX,'\\caption{Check plots.}');
            fprintf(fidTeX,'\\label{Fig:CheckPlots:%s}\n',int2str(plt));
            fprintf(fidTeX,'\\end{figure}\n');
            fprintf(fidTeX,' \n');
        end
    end
    hh = figure('Name','Check plots');
    k = 1;
    if TeX
        NAMES = [];
        TeXNAMES = [];
    end
    while (nbplt-1)*nstar+k <= length(x)
        kk = (nbplt-1)*nstar+k;
        [name,texname] = get_the_name(kk,TeX);
        if TeX
            NAMES = strvcat(NAMES,name);
            TeXNAMES = strvcat(TeXNAMES,texname);
        end    
        if lr ~= 0
            subplot(lr,lc,k)
        else
            subplot(nr,nc,k)
        end    
        xx = x;
        l1 = max(lb(kk),0.8*x(kk));
        l2 = min(ub(kk),1.2*x(kk));
        z = [l1:(l2-l1)/20:l2];
        y = zeros(length(z),1);
        for i=1:length(z)
            xx(kk) = z(i);
            y(i) = DsgeLikelihood(xx,gend,data);
        end
        plot(z,y)
        hold on
        yl=get(gca,'ylim');
        plot( [x(kk) x(kk)], yl, 'c', 'LineWidth', 1)
        title(name,'interpreter','none')
        hold off
        k = k + 1;
        drawnow
    end
    eval(['print -depsc2 ' fname_ '_CheckPlots' int2str(nbplt)]);
    eval(['print -dpdf ' fname_ '_CheckPlots' int2str(nbplt)]);
    saveas(hh,[fname_ '_CheckPlots' int2str(nbplt) '.fig']);
    if options_.nograph, close(hh), end
    if TeX
        fprintf(fidTeX,'\\begin{figure}[H]\n');
        for jj = 1:lr*lc
            fprintf(fidTeX,'\\psfrag{%s}[1][][0.5][0]{%s}\n',deblank(NAMES(jj,:)),deblank(TeXNAMES(jj,:)));
        end    
        fprintf(fidTeX,'\\centering \n');
        fprintf(fidTeX,'\\includegraphics[scale=0.5]{%s_CheckPlots%s}\n',fname_,int2str(nbplt));
        fprintf(fidTeX,'\\caption{Check plots.}');
        fprintf(fidTeX,'\\label{Fig:CheckPlots:%s}\n',int2str(nbplt));
        fprintf(fidTeX,'\\end{figure}\n');
        fprintf(fidTeX,' \n');
        fprintf(fidTeX,'%% End of TeX file.\n');
        fclose(fidTeX);
    end
end

% SA 07-31-2004		* New default : no more than nine plots per figure.
%					* Figures are automatically saved in eps, pdf and fig formats.
%					* Figures are automatically closed (this should be an option).
%					* Creation of a TeX-loader file for the postcript file. 