function plot_priors
% stephane.adjemian@cepremap.cnrs.fr [07-31-2004]
global bayestopt_ fname_ options_

TeX = options_.TeX;

figurename = 'Priors';
npar = length(bayestopt_.pmean);
[nbplt,nr,nc,lr,lc,nstar] = pltorg(npar);

if TeX
	fidTeX = fopen([fname_ '_Priors.TeX'],'w');
	fprintf(fidTeX,'%% TeX eps-loader file generated by plot_priors.m (Dynare).\n');
	fprintf(fidTeX,['%% ' datestr(now,0) '\n']);
	fprintf(fidTeX,' \n');
end
if nbplt == 1
    h1 = figure('Name',figurename);
    if TeX
        TeXNAMES = [];
        NAMES    = []; 
    end    
    for i=1:npar
        [x,f,abscissa,dens,binf,bsup] = draw_prior_density(i);
        [nam,texnam] = get_the_name(i,TeX);
        if TeX
            TeXNAMES = strvcat(TeXNAMES,texnam);
            NAMES = strvcat(NAMES,nam);
        end    
        subplot(nr,nc,i)
        hh = plot(x,f,'-k','linewidth',2);
        set(hh,'color',[0.7 0.7 0.7]);
        box on
        title(nam,'Interpreter','none')
        drawnow
    end
    print('-depsc2',[fname_ '_Priors' int2str(1)]);
    print('-dpdf',[fname_ '_Priors' int2str(1)]);
    saveas(h1,[fname_ '_Priors' int2str(1) '.fig']);
    if options_.nograph, close(h1), end
    if TeX
    	fprintf(fidTeX,'\\begin{figure}[H]\n');
        for jj = 1:npar
        	fprintf(fidTeX,'\\psfrag{%s}[1][][0.5][0]{%s}\n',deblank(NAMES(jj,:)),deblank(TeXNAMES(jj,:)));
        end    
        fprintf(fidTeX,'\\centering\n');
        fprintf(fidTeX,'\\includegraphics[scale=0.5]{%s_Priors%s}\n',fname_,int2str(1));
        fprintf(fidTeX,'\\caption{Priors.}');
        fprintf(fidTeX,'\\label{Fig:Priors:%s}\n',int2str(1));
        fprintf(fidTeX,'\\end{figure}\n');
        fprintf(fidTeX,' \n');
        fprintf(fidTeX,'%% End of TeX file.\n');
        fclose(fidTeX);
	end
else
    for plt = 1:nbplt-1
        hplt = figure('Name',figurename);
        if TeX
            TeXNAMES = [];
            NAMES    = []; 
        end    
        for index=1:nstar
            names = [];
            i = (plt-1)*nstar + index;
            [x,f,abscissa,dens,binf,bsup] = draw_prior_density(i);
            [nam,texnam] = get_the_name(i,TeX);
            if TeX
                TeXNAMES = strvcat(TeXNAMES,texnam);
                NAMES = strvcat(NAMES,nam);
            end    
            subplot(nr,nc,index)
            hh = plot(x,f,'-k','linewidth',2);
            set(hh,'color',[0.7 0.7 0.7]);
            box on
            title(nam,'Interpreter','none')
            drawnow
        end  % index=1:nstar
        print('-depsc2',[fname_ '_Priors' int2str(plt)]);
        print('-dpdf',[fname_ '_Priors' int2str(plt)]);
	saveas(hplt,[fname_ '_Priors' int2str(plt) '.fig']);
    	if options_.nograph, close(hplt), end
		if TeX
            fprintf(fidTeX,'\\begin{figure}[H]\n');
            for jj = 1:nstar
                fprintf(fidTeX,'\\psfrag{%s}[1][][0.5][0]{%s}\n',deblank(NAMES(jj,:)),deblank(TeXNAMES(jj,:)));
            end    
            fprintf(fidTeX,'\\centering\n');
            fprintf(fidTeX,'\\includegraphics[scale=0.5]{%s_Priors%s}\n',fname_,int2str(plt));
            fprintf(fidTeX,'\\caption{Priors.}');
            fprintf(fidTeX,'\\label{Fig:Priors:%s}\n',int2str(plt));
            fprintf(fidTeX,'\\end{figure}\n');
            fprintf(fidTeX,' \n');
        end    
    end % plt = 1:nbplt-1
    hplt = figure('Name',figurename);
    if TeX
        TeXNAMES = [];
        NAMES    = []; 
    end    
    for index=1:npar-(nbplt-1)*nstar
        i = (nbplt-1)*nstar +  index;
        [x,f,abscissa,dens,binf,bsup] = draw_prior_density(i);
        [nam,texnam] = get_the_name(i,TeX);
        if TeX
            TeXNAMES = strvcat(TeXNAMES,texnam);
            NAMES = strvcat(NAMES,nam);
        end    
        if lr
            subplot(lc,lr,index);
        else
            subplot(nr,nc,index);
        end    
        hh = plot(x,f,'-k','linewidth',2);
        set(hh,'color',[0.7 0.7 0.7]);
        box on
        title(nam,'Interpreter','none')
        drawnow
    end  % index=1:npar-(nbplt-1)*nstar
    print('-depsc2',[ fname_ '_Priors' int2str(nbplt)]);
    print('-dpdf',[ fname_ '_Priors' int2str(nbplt)]);
    saveas(hplt,[fname_ '_Priors' int2str(nbplt) '.fig']);
    if options_.nograph, close(hplt), end
	if TeX
        fprintf(fidTeX,'\\begin{figure}[H]\n');
        for jj = 1:npar-(nbplt-1)*nstar
            fprintf(fidTeX,'\\psfrag{%s}[1][][0.5][0]{%s}\n',deblank(NAMES(jj,:)),deblank(TeXNAMES(jj,:)));
        end    
        fprintf(fidTeX,'\\centering\n');
        fprintf(fidTeX,'\\includegraphics[scale=0.5]{%s_Priors%s}\n',fname_,int2str(nbplt));
        fprintf(fidTeX,'\\caption{Priors.}');
        fprintf(fidTeX,'\\label{Fig:Priors:%s}\n',int2str(nbplt));
        fprintf(fidTeX,'\\end{figure}\n');
        fprintf(fidTeX,' \n');
        fprintf(fidTeX,'%% End of TeX file.\n');
        fclose(fidTeX);
    end
end
