// --+ options: transform_unary_ops, json=compute, stochastic +--

var y x z;

varexo ex ey ez;

parameters a_y_1 a_y_2 b_y_1 b_y_2 b_x_1 b_x_2 g; // VAR parameters

parameters e_c_m c_z_1 c_z_2;               // PAC equation parameters

a_y_1 =  .2;
a_y_2 =  .3;
b_y_1 =  .1;
b_y_2 =  .4;
b_x_1 = -.1;
b_x_2 = -.2;

g = .1;

e_c_m =  .1;
c_z_1 =  .7;
c_z_2 = -.3;

@#include "example1/model/pac-expectations/pacman-parameters.inc"

model;

[name='eq:y']
y = a_y_1*y(-1) + a_y_2*diff(x(-1)) + b_y_1*y(-2) + b_y_2*diff(x(-2)) + ey ;

[name='eq:x']
diff(x) = b_x_1*y(-2) + b_x_2*diff(x(-1)) + g*(1-b_x_2)  + ex ;

[name='eq:pac']
diff(z) = e_c_m*(x(-1)-z(-1)) + c_z_1*diff(z(-1))  + c_z_2*diff(z(-2)) +
@#include "example1/model/pac-expectations/pacman-growth-neutrality-correction.inc"
+
@#include "example1/model/pac-expectations/pacman-expression.inc"
+ ez;

end;

shocks;
    var ex = 1.0;
    var ey = 1.0;
    var ez = 1.0;
end;

// Set initial conditions to zero. Please use more sensible values if any...
initialconditions = dseries(zeros(10, M_.endo_nbr+M_.exo_nbr), 2000Q1, vertcat(M_.endo_names,M_.exo_names));

// Simulate the model for 20 periods
set_dynare_seed('default');
TrueData = simul_backward_model(initialconditions, 20);

verbatim;
  set_dynare_seed('default');
  y = zeros(M_.endo_nbr,1);
  y(1:M_.orig_endo_nbr) = rand(M_.orig_endo_nbr, 1);
  x = randn(M_.exo_nbr,1);
  y = substitution.set_auxiliary_variables(y, x, M_.params);
  y3n = repmat(y, 3, 1);
  [residual, T_order, T] = substitution.sparse.dynamic_resid(y3n, x', M_.params, oo_.steady_state);
  g1 = substitution.sparse.dynamic_g1(y3n, x', M_.params, oo_.steady_state, M_.dynamic_g1_sparse_rowval, M_.dynamic_g1_sparse_colval, M_.dynamic_g1_sparse_colptr, T_order, T);
  example1 = load('example1.mat');
end;

if max(abs(example1.TrueData.data(:)-TrueData.data(:)))>1e-9
   error('Simulations do not match.')
end

if ~isequal(length(residual), length(example1.residual)) || max(abs(example1.residual-residual))>1e-8
  warning('Residuals do not match!')
end

if ~isequal(length(g1(:)), length(example1.g1(:))) || max(abs(example1.g1(:)-g1(:)))>1e-8
  warning('Jacobian matrices do not match!')
end

delete('example1.mat');
