function g2_legacy = legacy_dynamic_g2(g2_v, M_)
% Given g2 as returned by dynamic_g2.m, construct the g2 matrix in the legacy
% representation (see issue #1859 for the historical background). Ideally this
% file should go away when the identification code is adapted to the new model
% representation.

% Copyright © 2025 Dynare Team
%
% This file is part of Dynare.
%
% Dynare is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% Dynare is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with Dynare.  If not, see <https://www.gnu.org/licenses/>.

nvar = M_.nspred + M_.endo_nbr + M_.nsfwrd + M_.exo_nbr + M_.exo_det_nbr;
nnz = size(M_.dynamic_g2_sparse_indices, 1);

%% The g2_* arrays may be expanded if there are symmetric elements added
g2_i = int32(zeros(nnz, 1));
g2_j = int32(zeros(nnz, 1));

next_sym_idx = nnz + 1; % Index of next symmetric element to be added

for k = 1:length(g2_v)
    eq = M_.dynamic_g2_sparse_indices(k,1);
    var1 = identification.legacy_idx(M_.dynamic_g2_sparse_indices(k,2), M_) - 1;
    var2 = identification.legacy_idx(M_.dynamic_g2_sparse_indices(k,3), M_) - 1;

    g2_i(k) = eq;
    g2_j(k) = var1 * nvar + var2 + 1;

    %% Add symmetric elements, which are not included by sparse {static,dynamic}_g2.m
    if var1 ~= var2
        g2_i(next_sym_idx) = eq;
        g2_j(next_sym_idx) = var2 * nvar + var1 + 1;
        g2_v(next_sym_idx) = g2_v(k);
        next_sym_idx = next_sym_idx + 1;
    end
end

g2_legacy = sparse(g2_i, g2_j, g2_v, M_.endo_nbr, nvar ^ 2);
