function graph(var_list,M_, oo_,options_)
% function graph(var_list,M_, oo_,options_)
% Plots the classical forecasts created by forecasts.run
%
% Inputs:
%   o var_list              character array with variable names
%   o M_                    model structure
%   o oo_                   outputs structure
%   o options_              options structure

% Copyright © 2008-2025 Dynare Team
%
% This file is part of Dynare.
%
% Dynare is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% Dynare is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with Dynare.  If not, see <https://www.gnu.org/licenses/>.

nc = 4;
nr = 3;
endo_names = M_.endo_names;
fname = M_.fname;
dname = M_.dname;

yf = oo_.forecast.Mean;
hpdinf = oo_.forecast.HPDinf;
hpdsup = oo_.forecast.HPDsup;
if isempty(var_list)
    var_list = endo_names(1:M_.orig_endo_nbr);
end
i_var = [];
for i = 1:length(var_list)
    tmp = strmatch(var_list{i}, endo_names, 'exact');
    if isempty(tmp)
        error([var_list{i} ' isn''t an endogenous variable'])
    end
    i_var = [i_var; tmp];
end
nvar = length(i_var);

% create subdirectory <dname>/graphs if id doesn't exist
if ~isfolder(dname)
    mkdir('.',dname);
end
if ~isfolder([dname '/graphs'])
    mkdir(dname,'graphs');
end

if options_.TeX && any(strcmp('eps', cellstr(options_.graph_format)))
    fidTeX = write_LaTeX_header([M_.dname '/graphs/', fname, '_forcst.tex']);
end

m = 1;
n_fig = 1;
hh_fig = dyn_figure(options_.nodisplay, 'Name', 'Forecasts (I)');

for j= 1:nvar
    if m > nc*nr
        dyn_saveas(hh_fig,[ dname '/graphs/forcst' int2str(n_fig)], options_.nodisplay, options_.graph_format);
        if options_.TeX && any(strcmp('eps', cellstr(options_.graph_format)))
            fprintf(fidTeX,'\\begin{figure}[H]\n');
            fprintf(fidTeX,'\\centering \n');
            fprintf(fidTeX,'\\includegraphics[width=0.8\\textwidth]{%s/graphs/forcst%d}\n',dname,n_fig);
            fprintf(fidTeX,'\\label{Fig:forcst:%d}\n',n_fig);
            fprintf(fidTeX,'\\caption{Mean forecasts and %2.0f\\%% confidence intervals}\n',options_.forecasts.conf_sig*100);
            fprintf(fidTeX,'\\end{figure}\n');
            fprintf(fidTeX,' \n');
        end
        n_fig =n_fig+1;
        hh_fig=dyn_figure(options_.nodisplay,'Name',['Forecasts (' int2str(n_fig) ')']);
        m = 1;
    end
    subplot(nr, nc, m);
    vn = endo_names{i_var(j)};
    obs = 0;
    plot([NaN(obs,1); yf.(vn)],'b-');
    hold on
    plot([NaN(obs,1); hpdinf.(vn)],'b-');
    hold on
    plot([NaN(obs,1); hpdsup.(vn)],'b-');
    if options_.TeX
        temp=strmatch(vn,M_.endo_names,'exact');
        title(['$' M_.endo_names_tex{temp} '$'],'Interpreter','latex');
    else
        title(vn,'Interpreter','none');
    end
    xlim([1 obs+length(hpdsup.(vn))])
    hold off
    m = m + 1;
end

if m > 1
    dyn_saveas(hh_fig,[dname '/graphs/forcst' int2str(n_fig)],options_.nodisplay,options_.graph_format);
    if options_.TeX && any(strcmp('eps',cellstr(options_.graph_format)))
        fprintf(fidTeX,'\\begin{figure}[H]\n');
        fprintf(fidTeX,'\\centering \n');
        fprintf(fidTeX,'\\includegraphics[width=0.8\\textwidth]{%s/graphs/forcst%d}\n',dname,n_fig);
        fprintf(fidTeX,'\\label{Fig:forcst:%d}\n',n_fig);
        fprintf(fidTeX,'\\caption{Mean forecasts and %2.0f\\%% confidence intervals}\n',options_.forecasts.conf_sig*100);
        fprintf(fidTeX,'\\end{figure}\n');
        fprintf(fidTeX,' \n');
    end
end

if options_.TeX && any(strcmp('eps',cellstr(options_.graph_format)))
    write_LaTeX_footer(fidTeX);
end

if isfield(oo_.forecast,'HPDinf_ME')
    var_names=fieldnames(oo_.forecast.HPDinf_ME);

    if options_.TeX && any(strcmp('eps',cellstr(options_.graph_format)))
        fidTeX=write_LaTeX_header([M_.dname '/graphs/',fname,'_forcst_ME.tex']);
    end

    m = 1;
    n_fig = 1;
    hh_fig=dyn_figure(options_.nodisplay,'Name','Forecasts including ME (I)');
    for j= 1:length(var_names)
        if m > nc*nr
            dyn_saveas(hh_fig,[ dname '/graphs/forcst_ME' int2str(n_fig)],options_.nodisplay,options_.graph_format);
            if options_.TeX && any(strcmp('eps',cellstr(options_.graph_format)))
                fprintf(fidTeX,'\\begin{figure}[H]\n');
                fprintf(fidTeX,'\\centering \n');
                fprintf(fidTeX,'\\includegraphics[width=%2.2f\\textwidth]{%s/graphs/forcst_ME%d}\n',options_.figures.textwidth*min((m-1)/nc,1),dname,n_fig);
                fprintf(fidTeX,'\\label{Fig:forcst_ME:%d}\n',n_fig);
                fprintf(fidTeX,'\\caption{Mean forecasts and %2.0f\\%% confidence intervals accounting for measurement error}\n',options_.forecasts.conf_sig*100);
                fprintf(fidTeX,'\\end{figure}\n');
                fprintf(fidTeX,' \n');
            end
            n_fig =n_fig+1;
            hh_fig=dyn_figure(options_.nodisplay,'Name',['Forecasts including ME (' int2str(n_fig) ')']);
            m = 1;
        end
        subplot(nr,nc,m);
        vn = var_names{j};
        obs = 0;

        plot([NaN(obs,1); yf.(vn)],'b-');
        hold on
        plot([NaN(obs,1); oo_.forecast.HPDinf_ME.(vn)],'b-');
        hold on
        plot([NaN(obs,1); oo_.forecast.HPDsup_ME.(vn)],'b-');
        if options_.TeX
            temp=strmatch(vn,M_.endo_names,'exact');
            title(['$' M_.endo_names_tex{temp} '$'],'Interpreter','latex');
        else
            title(vn,'Interpreter','none');
        end
        xlim([1 obs+length(oo_.forecast.HPDsup_ME.(vn))])
        hold off
        m = m + 1;
    end

    if m > 1
        dyn_saveas(hh_fig,[dname '/graphs/forcst_ME' int2str(n_fig)],options_.nodisplay,options_.graph_format);
        if options_.TeX && any(strcmp('eps',cellstr(options_.graph_format)))
            fprintf(fidTeX,'\\begin{figure}[H]\n');
            fprintf(fidTeX,'\\centering \n');
            fprintf(fidTeX,'\\includegraphics[width=%2.2f\\textwidth]{%s/graphs/forcst_ME%d}\n',options_.figures.textwidth*min((m-1)/nc,1),dname,n_fig);
            fprintf(fidTeX,'\\label{Fig:forcst_ME:%d}\n',n_fig);
            fprintf(fidTeX,'\\caption{Mean forecasts and %2.0f\\%% confidence intervals accounting for measurement error}\n',options_.forecasts.conf_sig*100);
            fprintf(fidTeX,'\\end{figure}\n');
            fprintf(fidTeX,' \n');
        end
    end

    if options_.TeX && any(strcmp('eps',cellstr(options_.graph_format)))
        write_LaTeX_footer(fidTeX);
    end
end


function fidTeX=write_LaTeX_header(fname)
%% write LaTeX-Header
fidTeX = fopen(fname,'w');
fprintf(fidTeX,'%% TeX eps-loader file generated by Dynare''s forecast_graphs.m.\n');
fprintf(fidTeX,['%% ' datestr(now,0) '\n']);
fprintf(fidTeX,' \n');


function write_LaTeX_footer(fidTeX)
%% write LaTeX-Footer
fprintf(fidTeX,' \n');
fprintf(fidTeX,'%% End of TeX file.\n');
fclose(fidTeX);
