/* Test for estimation under discretionary optimal policy.
   Uses the data generated by dennis_1.mod */

var y i pi pi_c q;
varexo g u e;

parameters omega kappa sigma beta alpha;

alpha = 0.4;
beta = 0.99;
sigma = 1;
omega = 0.9;
kappa = 0.3;

model(linear);
y = y(+1) -(omega/sigma)*(i-pi(+1))+g;
pi =  beta*pi(+1)+kappa*y+u;
pi_c = pi+(alpha/(1-alpha))*(q-q(-1));
q = q(+1)-(1-alpha)*(i-pi(+1))+(1-alpha)*e;
end;

shocks;
  var g; stderr 1;
  var u; stderr 1;
  var e; stderr 1;
end;

planner_objective pi_c^2 + y^2;
discretionary_policy(instruments=(i),irf=0,planner_discount=beta);

varobs y i pi;

estimated_params;
  omega, normal_pdf, 0.9, 0.1;
  kappa, normal_pdf, 0.2, 0.1;
end;


matched_moments;
y;
pi;
y*y;
pi*pi;
y*y(-1);
pi*pi(-1);
y*y(-3);
pi*pi(-3);
end;

method_of_moments(
    % Necessary options
          mom_method = GMM                   % method of moments method; possible values: GMM|SMM
        , datafile   = 'dennis_simul.m' % name of filename with data

        , order = 1                 % order of Taylor approximation in perturbation
        % , penalized_estimator               % include deviation from prior mean as additional moment restriction and use prior precision as weight
        % , pruning                           % use pruned state space system at higher-order
        % , verbose                           % display and store intermediate estimation results
        , weighting_matrix = ['DIAGONAL','OPTIMAL'] % weighting matrix in moments distance objective function; possible values: OPTIMAL|IDENTITY_MATRIX|DIAGONAL|filename. Size of cell determines stages in iterated estimation, e.g. two state with ['DIAGONAL','OPTIMAL']
        % , weighting_matrix_scaling_factor=1 % scaling of weighting matrix in objective function
        , se_tolx=1e-6                        % step size for numerical computation of standard errors
        , TeX                                 % print TeX tables and graphics
        , mode_compute = 3                    % specifies the optimizer for minimization of moments distance
        , additional_optimizer_steps = [13]   % vector of additional mode-finders run after mode_compute
        , optim = ('TolFun'      , 1D-6       % termination tolerance on the function value, a positive scalar
                  ,'TolX'        , 1e-6       % termination tolerance on x, a positive scalar
                  )
        , silent_optimizer                  % run minimization of moments distance silently without displaying results or saving files in between
        , mode_check                               % plot the target function for values around the computed minimum for each estimated parameter in turn
    );