% EK_131viii_TC_05312021_for_DW.mod
% In Normal Time, A Tax Cut, Perfect Pass-through
var y_hat c_hat pi i_hat b_hat b_hat_y D_m t_hat xi_hat mu_hat l_hat r_c_hat s pi_H nx_hat varsigma_hat pi_F e p_F p_H sp_hat r_H_hat;
varexo delta y_hat_star zeta g_hat rho_hat p_star;
parameters nu sigma upsilon beta theta alpha varepsilon varphi eta rho chi psi_b b kappa Theta;

nu = 0.4;
sigma = 1;
upsilon = 0;
beta = 0.995;
theta = 0.75;
alpha = 0.25; % 0.25
varepsilon = 9;
varphi = 5;
eta = 7;
rho = 1/beta - 1;
chi = 1/3;
psi_b = 0.02;
b = 2.4;
Theta = (1 - alpha)/((1 - alpha) + alpha*varepsilon);
kappa = (1 - theta *beta)*(1 - theta)/theta*Theta;

model;
c_hat = y_hat_star + (1 - nu)/sigma*s + 1/sigma*zeta; % (23)
y_hat = nu*(2 - nu)*s + (1 - nu)*c_hat + nu*y_hat_star + g_hat; % (24)
xi_hat = xi_hat(+1) + i_hat - pi(+1) - rho_hat; % (25)
xi_hat = upsilon*l_hat - sigma*c_hat ; % (26)
pi_H = beta*pi_H(+1) - kappa*mu_hat; % (27)
mu_hat = xi_hat - (varphi + alpha)/(1 - alpha)*y_hat - nu*s; % (28)
l_hat = c_hat - eta*i_hat; % (29)
l_hat(-1) = l_hat + pi - D_m; % (30)
pi = pi_H + nu*s - nu*s(-1); % (32)
nx_hat = y_hat - nu*s - c_hat - g_hat; % (33)
s = e + p_star - p_H; % (34)
pi_H = p_H - p_H(-1); % (35)
pi_F = p_F - p_F(-1); % (36)
pi_F = s - s(-1) + pi_H; % (37)
t_hat = psi_b*b_hat(-1) + varsigma_hat; % (38)
b_hat = ( 1 + rho - psi_b)*b_hat(-1) + (1 + rho)*b*i_hat(-1) - (1 + rho)*b*pi + g_hat - varsigma_hat - chi*D_m; % (39)
sp_hat = t_hat - g_hat + (1 + rho)*b*pi; % Fiscal Surplus with the Inflation Tax
r_c_hat = i_hat - pi(+1); % Real Consumption Interest Rate
r_H_hat = i_hat - pi_H(+1); % Real Domestic Interest Rate
b_hat_y = b^(-1)*b_hat- y_hat; % Debt-output Ratio
varsigma_hat = - delta; % A Tax Cut




D_m = 1/chi*g_hat - 1/chi*varsigma_hat + 1/chi*b*(1 + rho)*i_hat(-1) - 1/chi*b*(1 + rho)*pi; % (40) Choose for MF fiscal Stimulus
% pi = 0; % (41) Choose for DF fiscal Stimulus

end;

initval;
y_hat = 0;
c_hat = 0;
pi = 0;
end;

steady;

check;

shocks;
var delta;
periods 1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41	42	43	44	45	46	47	48	49	50	51	52	53	54	55	56	57	58	59	60	61	62	63	64	65	66	67	68	69	70	71	72	73	74	75	76	77	78	79	80	81	82	83	84	85	86	87	88	89	90	91	92	93	94	95	96	97	98	99	100	101;
	values	1	0.5	0.25	0.125	0.0625	0.03125	0.015625	0.0078125	0.00390625	0.001953125	0.000976563	0.000488281	0.000244141	0.00012207	6.10352E-05	3.05176E-05	1.52588E-05	7.62939E-06	3.8147E-06	1.90735E-06	9.53674E-07	4.76837E-07	2.38419E-07	1.19209E-07	5.96046E-08	2.98023E-08	1.49012E-08	7.45058E-09	3.72529E-09	1.86265E-09	9.31323E-10	4.65661E-10	2.32831E-10	1.16415E-10	5.82077E-11	2.91038E-11	1.45519E-11	7.27596E-12	3.63798E-12	1.81899E-12	9.09495E-13	4.54747E-13	2.27374E-13	1.13687E-13	5.68434E-14	2.84217E-14	1.42109E-14	7.10543E-15	3.55271E-15	1.77636E-15	8.88178E-16	4.44089E-16	2.22045E-16	1.11022E-16	5.55112E-17	2.77556E-17	1.38778E-17	6.93889E-18	3.46945E-18	1.73472E-18	8.67362E-19	4.33681E-19	2.1684E-19	1.0842E-19	5.42101E-20	2.71051E-20	1.35525E-20	6.77626E-21	3.38813E-21	1.69407E-21	8.47033E-22	4.23516E-22	2.11758E-22	1.05879E-22	5.29396E-23	2.64698E-23	1.32349E-23	6.61744E-24	3.30872E-24	1.65436E-24	8.27181E-25	4.1359E-25	2.06795E-25	1.03398E-25	5.16988E-26	2.58494E-26	1.29247E-26	6.46235E-27	3.23117E-27	1.61559E-27	8.07794E-28	4.03897E-28	2.01948E-28	1.00974E-28	5.04871E-29	2.52435E-29	1.26218E-29	6.31089E-30	3.15544E-30	1.57772E-30	7.88861E-31	;	%	0.5
end;

simul(periods=2100);

subplot(4,3,1);
plot(oo_.endo_simul(1,2:32));
title('Response of Output')

subplot(4,3,2);
plot(oo_.endo_simul(2,2:32));
title('Response of Consumption')

subplot(4,3,3);
plot(oo_.endo_simul(3,2:32));
title('Response of Inflation')

subplot(4,3,4);
plot(oo_.endo_simul(4,2:32));
title('Response of Nominal Interest Rate')

subplot(4,3,5);
plot(oo_.endo_simul(5,2:32)),axis([0 30 -2.5 2.5]);
title('Response of Debt')

subplot(4,3,6);
plot(oo_.endo_simul(7,2:32));
title('Response of Money Growth')

subplot(4,3,7);
plot(oo_.endo_simul(8,2:32));
title('Response of Taxes')

subplot(4,3,8);
plot(oo_.endo_simul(12,2:32));
title('Response of Real Consumption rate')

subplot(4,3,9);
plot(oo_.endo_simul(18,2:32));
title('Nominal Exchange Rate')

subplot(4,3,10);
plot(oo_.endo_simul(13,2:32));
title('Response of TOT')

subplot(4,3,11);
plot(oo_.endo_simul(14,2:32));
title('Response of Domestic Inflation')

subplot(4,3,12);
plot(oo_.endo_simul(17,2:32));
title('Response of Imported Goods Inflation')
