% EK_131viii_TC_ZLB_Zshock_05312021_for_DW.mod
% In a Liquidity Trap, A Tax Cut, Perfect Pass-through
var y_hat c_hat pi i_hat b_hat b_hat_y D_m t_hat xi_hat mu_hat l_hat r_c_hat s pi_H nx_hat varsigma_hat pi_F e p_F p_H sp_hat rho_hat r_H_hat;
varexo delta y_hat_star zeta g_hat gamma p_star;
parameters nu sigma upsilon beta theta alpha varepsilon varphi eta rho chi psi_b b kappa Theta;

nu = 0.4;
sigma = 1;
upsilon = 0;
beta = 0.995;
theta = 0.75;
alpha = 0.25; % 0.25
varepsilon = 9;
varphi = 5;
eta = 7;
rho = 1/beta - 1;
chi = 1/3;
psi_b = 0.02;
b = 2.4;
Theta = (1 - alpha)/((1 - alpha) + alpha*varepsilon);
kappa = (1 - theta *beta)*(1 - theta)/theta*Theta;

model;
c_hat = y_hat_star + (1- nu)/sigma*s + 1/sigma*rho_hat; % (23)
y_hat = nu*(2 - nu)*s + (1 - nu)*c_hat + nu*y_hat_star + g_hat; % (24)
xi_hat = xi_hat(+1) + i_hat - pi(+1) - rho_hat; % (25)
xi_hat = upsilon*l_hat - sigma*c_hat ; % (26)
pi_H = beta*pi_H(+1) - kappa*mu_hat; % (27)
mu_hat = xi_hat - (varphi + alpha)/(1 - alpha)*y_hat - nu*s; % (28)
i_hat = max(-0.50125, 1/eta*(c_hat - l_hat)); % ZLB
l_hat(-1) = l_hat + pi - D_m; % (30)
pi = pi_H + nu*s - nu*s(-1); % (32)
nx_hat = y_hat - nu*s - c_hat - g_hat; % (33)
s = e + p_star - p_H; % (34)
pi_H = p_H - p_H(-1); % (35)
pi_F = p_F - p_F(-1); % (36)
pi_F = s - s(-1) + pi_H; % (37)
t_hat = psi_b*b_hat(-1) + varsigma_hat; % (38)
b_hat = ( 1 + rho - psi_b)*b_hat(-1) + (1 + rho)*b*i_hat(-1) - (1 + rho)*b*pi + g_hat - varsigma_hat - chi*D_m; % (39)
sp_hat = t_hat - g_hat + (1 + rho)*b*pi; % Fiscal Surplus with the Inflation Tax
r_c_hat = i_hat - pi(+1); % Real Consumption Interest Rate
r_H_hat = i_hat - pi_H(+1); % Real Domestic Interest Rate
b_hat_y = b^(-1)*b_hat- y_hat; % Debt-output Ratio
varsigma_hat = - delta; % A Tax Cut




D_m = 1/chi*g_hat - 1/chi*varsigma_hat + 1/chi*b*(1 + rho)*i_hat(-1) - 1/chi*b*(1 + rho)*pi; % (40) Choose for MF fiscal Stimulus
% pi = - c_hat + l_hat + eta*i_hat; % (46) and (49) Choose for DF fiscal Stimulus

rho_hat = gamma; % Adverse Demand Shock
end;

initval;
y_hat = 0;
c_hat = 0;
pi = 0;
end;

steady;

check;

shocks;
var delta;
periods 1:6;
values 1;
var gamma;
periods 1:6;
values -1;

end;

simul(periods=2100); % y_hat c_hat b_hat pi pi_H l_hat m s i_hat;

subplot(4,3,1);
plot(oo_.endo_simul(1,2:32));
title('Response of Output')

subplot(4,3,2);
plot(oo_.endo_simul(2,2:32));
title('Response of Consumption')

subplot(4,3,3);
plot(oo_.endo_simul(3,2:32));
title('Response of Inflation')

subplot(4,3,4);
plot(oo_.endo_simul(4,2:32));
title('Response of Nominal Interest Rate')

subplot(4,3,5);
plot(oo_.endo_simul(5,2:32)),axis([0 30 -2.5 2.5]);
title('Response of Debt')

subplot(4,3,6);
plot(oo_.endo_simul(7,2:32));
title('Response of Money Growth')

subplot(4,3,7);
plot(oo_.endo_simul(8,2:32));
title('Response of Taxes')

subplot(4,3,8);
plot(oo_.endo_simul(12,2:32));
title('Response of Real Consumption rate')

subplot(4,3,9);
plot(oo_.endo_simul(18,2:32));
title('Nominal Exchange Rate')

subplot(4,3,10);
plot(oo_.endo_simul(13,2:32));
title('Response of TOT')

subplot(4,3,11);
plot(oo_.endo_simul(14,2:32));
title('Response of Domestic Inflation')

subplot(4,3,12);
plot(oo_.endo_simul(17,2:32));
title('Response of Imported Goods Inflation')
